#version 140
#extension GL_EXT_gpu_shader4 : enable
//misty mountainsMod01.fsh  by oskanberg
//https://www.shadertoy.com/view/3dG3Rd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float SCALE = 50.;
const int MAX_STEPS = 350;
void main (void)
//void mainImage(out vec4 fragColor, vec2 fragCoord)
{
    // normalise to [-0.5, +0.5]
    vec2 nFragCoord = gl_FragCoord.xy / iResolution.xy - 0.5;
    vec2 nMouse = iMouse.xy / iResolution.xy - 0.5;
    
    // start above the ground
    vec3 ray = vec3(0.0, 8.6 + (iTime / 2.0), 1.0);
    vec3 direction = normalize(vec3(nFragCoord.x, 0.25, nFragCoord.y)) / 100.;
    
    float r;
    float steps;
    float height;
    while (steps++ < float(MAX_STEPS)) {
        r = texture2D(iChannel0, ray.xy / SCALE).r * 1.5;
        height = ray.z - r;
        
        // if it's this high it'll probably never hit anything
        // stop here for efficiency
        if (height > 4.) {
   			gl_FragColor = 1. - vec4(height/8.,0.5,0.5,0.);
            return;
        }
        
        if (height <= 0.0) {           
            gl_FragColor = vec4(steps*1.1/float(MAX_STEPS), 0.5, 0.5, 0.5);
        	return;
        }
 
        ray += direction * steps * 0.01;
    }
    
    gl_FragColor = 1. - vec4(height/8.,0.5,0.5,0.);
}
